// sbmviewer.h


#ifndef __SBMVIEWER__
#define __SBMVIEWER__

#include <gltools.h>
#include <GLFrustum.h>
#include <GLBatch.h>
#include <GLMatrixStack.h>
#include <GLGeometryTransform.h>
#include <StopWatch.h>

class SBMViewer
    {
    public:
        SBMViewer();
        virtual ~SBMViewer() {};

        void Initialize(void);                            // Wywoywana po utworzeniu kontekstu
        void Shutdown(void);                            // Wywoywana przed usuniciem kontekstu
        void Resize(GLsizei nWidth, GLsizei nHeight);    // Wywoywana przy zmianie rozmiaru okna, przynajmniej raz, gdy okno jest tworzone 
        void Render(void);                                // Wywoywana w celu aktualizacji widoku OpenGL
        
        // Te metody s uywane przez wywoujcy szkielet. Ustaw odpowiednie wewntrzne
        // zmienne chronione, aby poinformowa szkielet nadrzdny jaka jest dana konfiguracja
        inline GLuint GetWidth(void) { return screenWidth; }
        inline GLuint GetHeight(void) { return screenHeight; }
        inline GLboolean GetFullScreen(void) { return bFullScreen; }
        inline GLboolean GetAnimated(void) { return bAnimated; }

    protected:
        GLsizei     screenWidth;            // dana szeroko okna lub pulpitu
        GLsizei     screenHeight;            // dana wysoko okna lub pulpitu
        
        GLboolean bFullScreen;            // danie dziaania w trybie penoekranowym
        GLboolean bAnimated;            // danie cigych aktualizacji

        GLMatrixStack        modelViewMatrix;        // Macierz model-widok
        GLMatrixStack        projectionMatrix;        // Macierz rzutowania
        GLFrustum            viewFrustum;            // Frusta widoku
        GLGeometryTransform    transformPipeline;        // Potok przetwarzania geometrii
        GLFrame                cameraFrame;            // Ukad odniesienia kamery
        GLBatch             screenQuad;
        M3DMatrix44f        orthoMatrix;  

        GLuint                instancingProg;

        GLuint              square_vao;
        GLuint              square_vbo;
        GLuint              element_buffer;

        GLuint              hdrFBO[1];
        GLuint              brightPassFBO[4];
        GLuint                textures[1];
        GLuint                hdrTextures[1];
        GLuint                brightBlurTextures[5];
        GLuint                windowTexture;
        GLfloat                exposure;
        GLfloat                bloomLevel;
        GLfloat                texCoordOffsets[5*5*2];
    };
        
#endif // __SBMVIEWER__
